/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.netserver.websocket;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.netserver.ReadHandler;
import org.netbeans.modules.netserver.SocketServer;
import org.netbeans.modules.netserver.api.WebSocketReadHandler;
import org.netbeans.modules.netserver.websocket.Utils;
import org.netbeans.modules.netserver.websocket.WebSocketChanelHandler;
import org.netbeans.modules.netserver.websocket.WebSocketHandler7;
import org.netbeans.modules.netserver.websocket.WebSocketHandler75;
import org.netbeans.modules.netserver.websocket.WebSocketHandler76;

public class WebSocketServerImpl
extends SocketServer {
    protected static final Logger LOG = SocketServer.LOG;
    private volatile WebSocketReadHandler handler;

    public WebSocketServerImpl(SocketAddress address) throws IOException {
        this(address, true);
    }

    protected WebSocketServerImpl(SocketAddress address, boolean onlyWebSocket) throws IOException {
        super(address);
        if (onlyWebSocket) {
            this.setReadHandler(new WebSocketHandler());
        }
    }

    public void setWebSocketReadHandler(WebSocketReadHandler handler) {
        this.handler = handler;
    }

    public WebSocketReadHandler getWebSocketReadHandler() {
        return this.handler;
    }

    public void sendMessage(SelectionKey key, String message) {
        byte[] bytes = this.getHandler(key).createTextFrame(message);
        this.send(bytes, key);
    }

    @Override
    public void close(SelectionKey key) throws IOException {
        super.close(key);
        this.getWebSocketReadHandler().closed(key);
    }

    @Override
    protected Queue<ByteBuffer> getWriteQueue(SelectionKey key) {
        return this.getContext(key).getQueue();
    }

    @Override
    protected SocketAddress getAddress() {
        return super.getAddress();
    }

    @Override
    protected void initWriteQueue(SelectionKey key) {
        if (key.attachment() == null) {
            key.attach(new SocketContext());
        }
    }

    @Override
    protected WebSocketHandler getReadHandler() {
        return (WebSocketHandler)super.getReadHandler();
    }

    SocketContext getContext(SelectionKey key) {
        return (SocketContext)key.attachment();
    }

    void setHandler(WebSocketChanelHandler handler, SelectionKey key) {
        this.getContext(key).setHandler(handler);
    }

    WebSocketChanelHandler getHandler(SelectionKey key) {
        return this.getContext(key).getHandler();
    }

    protected class WebSocketHandler
    implements ReadHandler {
        private ByteBuffer byteBuffer = ByteBuffer.allocate(1000);

        WebSocketHandler() {
        }

        @Override
        public void read(SelectionKey key) throws IOException {
            if (WebSocketServerImpl.this.getContext(key).getHeaders() != null) {
                WebSocketServerImpl.this.getContext(key).getHandler().read(this.byteBuffer);
            } else {
                this.handshake(key);
            }
        }

        protected void handshake(SelectionKey key) throws IOException {
            SocketChannel socketChannel = (SocketChannel)key.channel();
            try {
                if (!this.readHttpRequest(socketChannel, key)) {
                    WebSocketServerImpl.this.close(key);
                    return;
                }
                this.initHandler(key);
                WebSocketServerImpl.this.getWebSocketReadHandler().accepted(key);
            }
            catch (IOException e) {
                WebSocketServerImpl.this.close(key);
            }
        }

        protected void initHandler(SelectionKey key) throws IOException {
            Map<String, String> headers = WebSocketServerImpl.this.getContext(key).getHeaders();
            String version = headers.get("Sec-WebSocket-Version");
            if (version == null) {
                if (headers.containsKey("Sec-WebSocket-Key1")) {
                    this.handshakeVersion76(key);
                } else {
                    this.handshakeVersion75(key);
                }
            } else {
                this.handshakeVersion7(key);
            }
            WebSocketChanelHandler handler = WebSocketServerImpl.this.getHandler(key);
            if (handler == null) {
                LOG.log(Level.WARNING, "Unexpected protocol version. Chanel handler is null.");
                WebSocketServerImpl.this.close(key);
                return;
            }
            handler.sendHandshake();
        }

        private void handshakeVersion7(SelectionKey key) {
            WebSocketServerImpl.this.setHandler(new WebSocketHandler7(WebSocketServerImpl.this, key), key);
        }

        private void handshakeVersion75(SelectionKey key) {
            WebSocketServerImpl.this.setHandler(new WebSocketHandler75(WebSocketServerImpl.this, key), key);
        }

        private void handshakeVersion76(SelectionKey key) {
            WebSocketServerImpl.this.setHandler(new WebSocketHandler76(WebSocketServerImpl.this, key), key);
        }

        protected boolean readHttpRequest(SocketChannel socketChannel, SelectionKey key) throws IOException {
            byte[] content = new byte[8];
            List<String> headers = Utils.readHttpRequest(socketChannel, this.byteBuffer, content);
            if (headers != null) {
                this.setHeaders(key, headers, content);
                return true;
            }
            return false;
        }

        private void setHeaders(SelectionKey key, List<String> headerLines, byte[] content) {
            if (headerLines.size() > 0) {
                WebSocketServerImpl.this.getContext(key).setRequest(headerLines.get(0));
            }
            HashMap<String, String> result = new HashMap<String, String>();
            for (String line : headerLines) {
                int index = line.indexOf(58);
                if (index == -1) continue;
                result.put(line.substring(0, index), line.substring(index + 1).trim());
            }
            WebSocketServerImpl.this.getContext(key).setHeaders(result);
            WebSocketServerImpl.this.getContext(key).setContent(content);
        }
    }

    static class SocketContext {
        private final Queue<ByteBuffer> writeQueue = new ConcurrentLinkedQueue<ByteBuffer>();
        private volatile Map<String, String> headers;
        private volatile String httpRequest;
        private volatile WebSocketChanelHandler handler;
        private volatile byte[] content;

        Queue<ByteBuffer> getQueue() {
            return this.writeQueue;
        }

        Map<String, String> getHeaders() {
            return this.headers;
        }

        void setHeaders(Map<String, String> headers) {
            this.headers = headers;
        }

        String getRequestString() {
            return this.httpRequest;
        }

        byte[] getContent() {
            return this.content;
        }

        void setRequest(String request) {
            this.httpRequest = request;
        }

        void setHandler(WebSocketChanelHandler handler) {
            this.handler = handler;
        }

        void setContent(byte[] content) {
            this.content = content;
        }

        WebSocketChanelHandler getHandler() {
            return this.handler;
        }
    }
}

